{========================================================================}
{=                (c) 1995-98 SwiftSoft Ronald Dittrich                 =}
{========================================================================}
{=                          All Rights Reserved                         =}
{========================================================================}
{=  D 01099 Dresden             = Fax.: +49 (0)351-8037944              =}
{=  Loewenstr.7a                = info@swiftsoft.de                     =}
{========================================================================}
{=  Actual versions on http://www.swiftsoft.de/mmtools.html             =}
{========================================================================}
{=  This code is for reference purposes only and may not be copied or   =}
{=  distributed in any format electronic or otherwise except one copy   =}
{=  for backup purposes.                                                =}
{=                                                                      =}
{=  No Delphi Component Kit or Component individually or in a collection=}
{=  subclassed or otherwise from the code in this unit, or associated   =}
{=  .pas, .dfm, .dcu, .asm or .obj files may be sold or distributed     =}
{=  without express permission from SwiftSoft.                          =}
{=                                                                      =}
{=  For more licence informations please refer to the associated        =}
{=  HelpFile.                                                           =}
{========================================================================}
{=  $Date: 06.09.98 - 14:37:55 $                                        =}
{========================================================================}
unit Unit2;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons, ExtCtrls, MMUtils, MMWave,
  MMSystem, MMPCMSup;

type
  TFmtDialog = class(TForm)
    GrpChannels: TRadioGroup;
    GrpBitLength: TRadioGroup;
    GrpSampleRate: TRadioGroup;
    btOK: TButton;
    btCancel: TButton;
    procedure FormShow(Sender: TObject);
    procedure GrpChannelsClick(Sender: TObject);
    procedure GrpBitLengthClick(Sender: TObject);
    procedure GrpSampleRateClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormHide(Sender: TObject);
  public
    Wave: TMMWave;
    PWaveFormat: PWaveFormatEx;
    Channels: Byte;
    BitLength: Byte;
    SampleRate: Longint;
  end;

var
  FmtDialog: TFmtDialog;

implementation

{$R *.DFM}

{-- TForm2 ---------------------------------------------------------------}
procedure TFmtDialog.FormCreate(Sender: TObject);
begin
   PWaveFormat := GlobalAllocMem(sizeOf(TWaveFormatEx));
end;

{-- TForm2 ---------------------------------------------------------------}
procedure TFmtDialog.FormDestroy(Sender: TObject);
begin
   GlobalFreeMem(pointer(PWaveFormat));
end;

{-- TForm2 ---------------------------------------------------------------}
procedure TFmtDialog.FormShow(Sender: TObject);
begin
     if (Wave <> Nil) then
     begin
          Channels := Ord(Wave.Mode)+1;
          BitLength := Wave.BitLength;
          SampleRate := Wave.SampleRate;
     end
     else
     begin
          Channels := 1;
          BitLength := 8;
          SampleRate := 11025;
     end;

     GrpChannels.ItemIndex := Channels-1;
     GrpBitLength.ItemIndex := (BitLength div 8)-1;
     case Cardinal(SampleRate) of
          8000..10099: GrpSampleRate.ItemIndex := 0;
         11000..21999: GrpSampleRate.ItemIndex := 1;
         22000..31999: GrpSampleRate.ItemIndex := 2;
         32000..39999: GrpSampleRate.ItemIndex := 3;
         40000..44150: GrpSampleRate.ItemIndex := 4;
                  else GrpSampleRate.ItemIndex := 5;
     end;
end;

{-- TForm2 ---------------------------------------------------------------}
procedure TFmtDialog.GrpChannelsClick(Sender: TObject);
begin
     Channels := GrpChannels.ItemIndex+1;
end;

{-- TForm2 ---------------------------------------------------------------}
procedure TFmtDialog.GrpBitLengthClick(Sender: TObject);
begin
     BitLength := (GrpBitLength.ItemIndex+1) * 8;
end;

{-- TForm2 ---------------------------------------------------------------}
procedure TFmtDialog.GrpSampleRateClick(Sender: TObject);
begin
     case GrpSampleRate.ItemIndex of
          0: SampleRate := 8000;
          1: SampleRate := 11025;
          2: SampleRate := 22050;
          3: SampleRate := 32000;
          4: SampleRate := 44100;
          5: SampleRate := 48000;
     end;
end;

{-- TForm2 ---------------------------------------------------------------}
procedure TFmtDialog.FormHide(Sender: TObject);
begin
   { build the destination format header }
   pcmBuildWaveHeader(PWaveFormat, BitLength, Channels, SampleRate);
end;

end.
 
